package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;

//import org.apache.poi.util.SystemOutLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ManageSql extends ValidatorEJB {
	
		public String wfValData() throws RemoteException, ITMException
		{
			return "";
		}

		public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
		{
			System.out.println("Inside wfValData updated method 20/07/22 ::: Ajit");
			Document dom = null;
			Document dom1 = null;
			Document dom2 = null;
			String errString = null;
			GenericUtility genericUtility = GenericUtility.getInstance();
			try
			{
				System.out.println("wfValData value of xmlString ["+xmlString+"]");
				System.out.println("wfValData value of xmlString ["+xmlString1+"]");
				System.out.println("wfValData value of xmlString ["+xmlString2+"]");
				if (xmlString != null && xmlString.trim().length()!=0)
				{
					dom = genericUtility.parseString(xmlString);
				}
				if (xmlString1 != null && xmlString1.trim().length()!=0)
				{
					dom1 = genericUtility.parseString(xmlString1);
				}
				if (xmlString2 != null && xmlString2.trim().length()!=0)
				{
					dom2 = genericUtility.parseString(xmlString2);
				}
				errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
				System.out.println ("ErrString: " + errString);
			}
			catch (Exception e)
			{
				System.out.println ("Exception: wfValData(String xmlString): " + e.getMessage() + ":");
				errString = genericUtility.createErrorString(e);
				e.printStackTrace();
			}
			System.out.println ("Returning from  wfValData");
			return (errString);
		}

		public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			System.out.println("20/07/22 ::: jay");
            try {
    			BaseLogger.log("3", getUserInfo(), null,  "dom case2*>>>> Elements>>["+genericUtility.serializeDom(dom).toString()+"]");//added for testing
                BaseLogger.log("3", getUserInfo(), null,  "dom2 case2*>>>> Elements>>["+genericUtility.serializeDom(dom2).toString()+"]");//added for testing
				BaseLogger.log("3", getUserInfo(), null,  "dom1 case2*>>>> Elements>>["+genericUtility.serializeDom(dom1).toString()+"]");
			} catch (BaseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}//added for testing


			String userId = "";

			String requestId = "";//changed by Ashish.J
			String sql="";
			String errString = "";

			Connection connection = null;
			ResultSet rs = null;
			PreparedStatement pstmt = null;

			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = null;
			ITMDBAccessEJB itmDBAccess = null;

			String reqid="";//changed by Ashish.J
			int noOfChilds = 0;
			int currentFormNo = 0;

			try
			{
				SimpleDateFormat DOB = new SimpleDateFormat(getApplDateFormat());
				itmDBAccess = new ITMDBAccessEJB();
				connection = getConnection(); 

				userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				if(objContext != null && objContext.trim().length()>0)
				{
					currentFormNo = Integer.parseInt(objContext);
				}
				switch ( currentFormNo )
				{
					case 1:
					{
						parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
						int parentNodeListLength = parentList.getLength();
						System.out.println("parentNodeListLength["+parentNodeListLength+"]");

						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							System.out.println("value of parentNode"+parentNode);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							System.out.println("value of noOfChilds"+noOfChilds);
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								System.out.println("childNode"+childNode);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								childNodeName = childNode.getNodeName();

								
								if( childNodeName.equalsIgnoreCase("enterprises") )
								{
								    
									String appldb = checkNull(genericUtility.getColumnValue("appl_db", dom));


									if (childNode.getFirstChild() == null ) 
									{
										if(appldb.equalsIgnoreCase("S"))
										{
											errString = getErrorString("enterprises","NULENTRPRS",userId);
											break;
										}
									}
									else
									{
									    String enterprise = checkNull(getColumnValue("enterprises",dom,"1"));
										String [] temp = enterprise.split(",");
										for(int i = 0 ;i < temp.length;i++)
										{
											String ent = temp[i];
											int count=0;
											sql = "SELECT COUNT(*) AS COUNT FROM ENTERPRISE WHERE ENTERPRISE=?";
											System.out.println("pophelp query for enterprise " + sql);
											pstmt = connection.prepareStatement(sql);
											pstmt.setString(1, ent);
											rs = pstmt.executeQuery();
											if( rs.next() )
											{
												count  = rs.getInt("COUNT");
											}
											if ( rs != null )
											{
												rs.close();
												rs = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
											   errString = getErrorString("enterprises","INVENTRPRS",userId);
										       break;
											}
										}
										
										

									}
								}
								
								if( childNodeName.equalsIgnoreCase("req_id") )
								{
									reqid = genericUtility.getColumnValue("req_id", dom);//changed by Ashish.J
									if (reqid!=null && reqid.trim().length()>0 )	
									{
										sql = "SELECT COUNT(*) AS COUNT FROM SER_REQUEST WHERE REQ_ID =?";
										pstmt = connection.prepareStatement(sql);
										pstmt.setString(1,reqid);
										rs = pstmt.executeQuery();
										int count = 0;
										if( rs.next() )
										{
											count  = rs.getInt("COUNT");
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
	                                       System.out.println("not a Valid Field name"+reqid);
										   errString = getErrorString("req_id","INVLDREQID",userId);
									       break;
										}
									}
								}
								
								if( childNodeName.equalsIgnoreCase("itm_ver") )
								{
									if (childNode.getFirstChild() == null ) 
									{
										
									}
									else
									{
										String div = checkNull(getColumnValue("itm_ver",dom,"1"));

										sql = "SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE ITEM_SER =?";
										pstmt = connection.prepareStatement(sql);
										pstmt.setString(1,div);
										rs = pstmt.executeQuery();
										int count = 0;
										if( rs.next() )
										{
											count  = rs.getInt("COUNT");
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
	                                       System.out.println("not a Valid Field name"+div);
										   errString = getErrorString("itm_ver","INVLDDIV",userId);
									       break;
										}
									}
								}
								
								if( childNodeName.equalsIgnoreCase("emp_code__given") )
								{
									if (childNode.getFirstChild() == null ) 
									{
										
									}
									else
									{
										String empcg = checkNull(getColumnValue("emp_code__given",dom,"1"));

										sql = "SELECT COUNT(1) NAME FROM USERS WHERE CODE =?";

										pstmt = connection.prepareStatement(sql);
										pstmt.setString(1,empcg);
										rs = pstmt.executeQuery();
										int count = 0;
										if( rs.next() )
										{
											count  = rs.getInt(1);
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
										   errString = getErrorString("emp_code__given","INVLDSUB",userId);
									       break;
										}
									}
								}
								
								if( childNodeName.equalsIgnoreCase("emp_code__merge") )
								{
									if (childNode.getFirstChild() == null ) 
									{
										
									}
									else
									{
										String empcm = checkNull(getColumnValue("emp_code__merge",dom,"1"));

										sql = "SELECT COUNT(1) NAME FROM USERS WHERE CODE =?";
										System.out.println("pophelp query for enterprise " + sql);
										pstmt = connection.prepareStatement(sql);
										pstmt.setString(1,empcm);
										rs = pstmt.executeQuery();
										int count = 0;
										if( rs.next() )
										{
											count  = rs.getInt(1);
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
	                                       System.out.println("not a Valid Field name"+empcm);
										   errString = getErrorString("emp_code__merge","INVLDMER",userId);
									       break;
										}
									}
								}
								//End elseif
							}//End for loop
						}//End for loop
						break;
					}//case1
				}//switch
			
			}//try
			catch (Exception e)
			{
				System.out.println ("Exception: wfValData(Document dom): " + e.getMessage() + ":");
				errString = genericUtility.createErrorString(e);
				throw new ITMException(e); 
			}
			finally
			{
				try
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(connection != null)
					{
						connection.close();
						connection = null;
					}
	            }
				catch(Exception e)
				{
					errString = genericUtility.createErrorString(e);
				}
			}
			return (errString);
		}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
		String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{

		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try {
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			if (xmlString != null && xmlString.trim().length() != 0) {
				BaseLogger.log("3", null, null, "itemchange header xmlString>>>>" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				BaseLogger.log("3", null, null, "xmlString1>>>>" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				BaseLogger.log("3", null, null, "xmlString2>>>>" + xmlString2);
				dom2 = genericUtility.parseString(xmlString2);
				BaseLogger.log("3", null, null, "dom2:::-" + genericUtility.serializeDom(dom2));
			}

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);

		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Exception itemChanged::::" + e.getMessage() + ":");
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null, "returning from itemChanged method");

		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println(" itemchange method called...");

		BaseLogger.log("3", null, null, "Itemchanged Called");
		StringBuffer valueXmlString = new StringBuffer();
		
		int currentFormNo = 0;
		String userId = "",sql="",empmcode="";//changed by Ashish.J

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn=null;
		try 
		{

			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			conn = getConnection();

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");//changed by Ashish.J


			if (objContext != null && objContext.trim().length() > 0)
				currentFormNo = Integer.parseInt(objContext);

			currentColumn = currentColumn == null ? "" : currentColumn.trim();
			SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getApplDateFormat());

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) 
			{
			case 1:// first From //this code for auto date generates
				valueXmlString.append("<Detail1>");
				if ("itm_default".equalsIgnoreCase(currentColumn))
				{
					Date dte = new Date();
					String currentDate = "";
					currentDate = formatter.format(dte);
					valueXmlString.append("<tran_date>").append("<![CDATA[" + currentDate + "]]>").append("</tran_date>");
					valueXmlString.append("<emp_code__given>").append("<![CDATA[" + userId + "]]>").append("</emp_code__given>");//changed by Ashish.J
					valueXmlString.append("<emp_code__merge>").append("<![CDATA[" + userId + "]]>").append("</emp_code__merge>");
					valueXmlString.append("<exec_rights>").append("<![CDATA[A]]>").append("</exec_rights>");

					sql = "SELECT  NAME FROM USERS WHERE CODE='" + userId + "'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String empgName = "";
					if (rs.next()) 
					{
						empgName = rs.getString("NAME") != null ? rs.getString("NAME").trim() : "";

					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<name><![CDATA[").append(empgName).append("]]></name>\r\n");
					valueXmlString.append("<users_name><![CDATA[").append(empgName).append("]]></users_name>\r\n");
					//changed by Ashish.J
				}
				else if ("itm_defaultedit".equalsIgnoreCase(currentColumn))
				{
					String applDB = checkNull(genericUtility.getColumnValue("appl_db", dom));
					String selEnterprises = checkNull(genericUtility.getColumnValue("enterprises", dom));

					if (applDB.equalsIgnoreCase("E")) 
					{
						valueXmlString.append("<enterprises protect='1'>").append("<![CDATA[" + selEnterprises + "]]>").append("</enterprises>");

					}
					else 
					{
						valueXmlString.append("<enterprises protect='0'>").append("<![CDATA[" + selEnterprises + "]]>").append("</enterprises>");
					}
					//changed by Ashish.J
					valueXmlString.append("<emp_code__given>").append("<![CDATA[" + userId + "]]>").append("</emp_code__given>");
					
					sql = "SELECT  NAME FROM USERS WHERE CODE='" + userId + "'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String empgName = "";
					if (rs.next()) 
					{
						empgName = rs.getString("NAME") != null ? rs.getString("NAME").trim() : "";

					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<name><![CDATA[").append(empgName).append("]]></name>\r\n");
					//changed by Ashish.J
				}
				else if (currentColumn.trim().equalsIgnoreCase("req_id")) 
				{
					Timestamp requestDate = null;//changed by Ashish.J
					String reqID = checkNull(genericUtility.getColumnValue("req_id", dom));
					sql = "select req_date from ser_request where req_id= '" + reqID + "'";

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next()) 
					{
						requestDate = rs.getTimestamp("req_date");
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					//changed by Ashish.J
					//formatter = new SimpleDateFormat(genericUtility.getApplDateFormat());
					//String reqDate = formatter.format(requestDate);
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

					if(requestDate !=null) 
					{
						//valueXmlString.append("<req_date>").append("<![CDATA[" + requestDate + "]]>").append("</req_date>");
						valueXmlString.append("<req_date>").append("<![CDATA["+ sdf.format(requestDate).toString() +"]]>").append("</req_date>");
					}
					else
					{
						//valueXmlString.append("<req_date>").append("<![CDATA[" + "" + "]]>").append("</req_date>");
						valueXmlString.append("<req_date>").append("<![CDATA["+ "" +"]]>").append("</req_date>");
					}//changed by Ashish.J

				}

				else if ("appl_db".equalsIgnoreCase(currentColumn)) {

					String appldb = checkNull(genericUtility.getColumnValue("appl_db", dom));


					if (appldb.equalsIgnoreCase("E")) 
					{
						valueXmlString.append("<enterprises protect='1'>").append("</enterprises>");
					}

					else 
					{
						valueXmlString.append("<enterprises protect='0'>").append("</enterprises>");
					}

				}


				else if ("emp_code__given".equalsIgnoreCase(currentColumn)) 
				{

					String empgcode = checkNull(genericUtility.getColumnValue("emp_code__given", dom));

					sql = "SELECT  NAME FROM USERS WHERE CODE='" + empgcode + "'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String empgName = "";
					if (rs.next()) 
					{
						empgName = rs.getString("NAME") != null ? rs.getString("NAME").trim() : "";

					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<name><![CDATA[").append(empgName).append("]]></name>\r\n");


				}

				else if ("emp_code__merge".equalsIgnoreCase(currentColumn)) 
				{


					empmcode = checkNull(genericUtility.getColumnValue("emp_code__merge", dom));

					sql = "SELECT NAME FROM USERS WHERE CODE='" + empmcode + "'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String empmName = "";
					if (rs.next()) 
					{
						empmName = rs.getString("NAME") != null ? rs.getString("NAME").trim() : "";
					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<users_name><![CDATA[").append(empmName).append("]]></users_name>\r\n");
				}

			/*	else if ("enterprises".equalsIgnoreCase(currentColumn)) 
				{
					String entrpcode = genericUtility.getColumnValue("enterprises", dom1);

					String sql = "SELECT ENTERPRISE_DESCR FROM ENTERPRISE WHERE ENTERPRISE in('"+ entrpcode.replaceAll(",", "','") + "')";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String entrpname = "";
					while (rs.next()) 
					{
						String enterpriseDescr = rs.getString("ENTERPRISE_DESCR");
						if (entrpname.length() == 0) 
						{
							entrpname = enterpriseDescr;
						} 
						else 
						{
							entrpname = entrpname + " , " + enterpriseDescr;
						}

					}


					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<enterprise_descr><![CDATA[").append(entrpname).append("]]></enterprise_descr>\r\n");

				} */
				else if ("itm_ver".equalsIgnoreCase(currentColumn)) 
				{



					String itmver = checkNull(genericUtility.getColumnValue("itm_ver", dom));

					sql = "SELECT DESCR FROM ITEMSER WHERE ITEM_SER='" + itmver + "'";

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String itmvername = "";
					if (rs.next()) 
					{
						System.out.println("enter in customer");
						itmvername = rs.getString("DESCR") != null ? rs.getString("DESCR").trim() : "";

					}

					if (rs != null) 
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<descr><![CDATA[").append(itmvername).append("]]></descr>\r\n");


				}

				valueXmlString.append("</Detail1>");
				break;
			}// End Switch
			valueXmlString.append("</Root>");
		} // End Try
		catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("3", null, null, "Exception ::" + e.getMessage());
			throw new ITMException(e);
		} finally 
		{
			try 
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn!= null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		BaseLogger.log("3", null, null, "\n HealthProfile:ValueXmlString :" + valueXmlString + ":*******");
		return valueXmlString.toString();

	}

	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}